/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.foundation.utility.CreateResourceReloader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class RecipeFinder {
    private static final Cache<Object, List<class_8786<?>>> CACHED_SEARCHES = CacheBuilder.newBuilder().build();
    public static final class_4013 LISTENER = new ReloadListener();

    public static List<class_8786<?>> get(@Nullable Object cacheKey, class_3218 level, Predicate<class_8786<?>> conditions) {
        if (cacheKey == null) {
            return RecipeFinder.startSearch(level, conditions);
        }
        try {
            return (List)CACHED_SEARCHES.get(cacheKey, () -> RecipeFinder.startSearch(level, conditions));
        }
        catch (ExecutionException e) {
            Create.LOGGER.error("Encountered a exception while searching for recipes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<class_8786<?>> startSearch(class_3218 level, Predicate<? super class_8786<?>> conditions) {
        ArrayList recipes = new ArrayList();
        for (class_8786 r : level.method_64577().method_8126()) {
            if (!conditions.test(r)) continue;
            recipes.add(r);
        }
        return recipes;
    }

    private static class ReloadListener
    extends CreateResourceReloader {
        public ReloadListener() {
            super("recipe_search");
        }

        public void method_14491(class_3300 resourceManager) {
            CACHED_SEARCHES.invalidateAll();
        }
    }
}

